﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

using MojaDrugaGra;

namespace Mgla;

public class Game1 : Game
{
    private GraphicsDeviceManager _graphics;
    private SpriteBatch _spriteBatch;

    public Game1()
    {
        _graphics = new GraphicsDeviceManager(this);
        Content.RootDirectory = "Content";
        IsMouseVisible = true;
    }

	BasicEffect efekt;
    Prostopadloscian tunel;

    protected override void Initialize()
    {
        _graphics.GraphicsDevice.RasterizerState = RasterizerState.CullClockwise;

        efekt = new BasicEffect(_graphics.GraphicsDevice);
        efekt.VertexColorEnabled = true;
        efekt.Projection = Matrix.CreatePerspective(
                2.0f * _graphics.GraphicsDevice.Viewport.AspectRatio,
                2.0f,
                1.0f,
                10.0f);
            efekt.View = Matrix.CreateLookAt(
                new Vector3(0, 0, 2.5f),
                new Vector3(0, 0, 0),
                new Vector3(0, 1, 0)
                );
            efekt.World = Matrix.Identity;

            //mgła
            efekt.FogStart = 0.2f;
            efekt.FogEnd = 5f;
            efekt.FogColor = Color.White.ToVector3();
            efekt.FogEnabled = true;

            //aktor
            tunel = new Prostopadloscian(this, efekt, 2.5f, 1.5f, 15f, null);
            tunel.MacierzSwiata = Matrix.CreateScale(0.75f);
            this.Components.Add(tunel);

        base.Initialize();
    }

    protected override void LoadContent()
    {
        _spriteBatch = new SpriteBatch(GraphicsDevice);

        // TODO: use this.Content to load your game content here
    }

    protected override void Update(GameTime gameTime)
    {
        if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed || Keyboard.GetState().IsKeyDown(Keys.Escape))
            Exit();

        // TODO: Add your update logic here

        base.Update(gameTime);
    }

    protected override void Draw(GameTime gameTime)
    {
        GraphicsDevice.Clear(Color.Black);

        // TODO: Add your drawing code here

        base.Draw(gameTime);
    }
}
